<?php

class MainControllerTest extends WebControllerTestCase
{
	/**
	 * FS#77 - Przekierowanie admin/nauczyciel
	 * http://pyramidlab.pl/tasks/index.php?do=details&task_id=77&project=1
	 */
	public function testTeacherAdminRedirection()
	{
		//not authorized
		$this->logout();
		$this->clickAndWait('link=Panel nauczyciela');
		$this->assertLocation(TEST_BASE_URL . 'administration/main/login');

		//teacher
		$this->login('teacher');
		$this->open('');
		$this->clickAndWait('link=Panel nauczyciela');
		$this->assertLocation(TEST_BASE_URL . 'teacher/main/index');

		//admin
		$this->login('admin', true);
		$this->open('');
		$this->clickAndWait('link=Panel nauczyciela');
		$this->assertLocation(TEST_BASE_URL . 'administration/main/index');

		//student
		$this->login('student', true);
		$this->open('');
		$this->assertElementNotPresent('link=Panel nauczyciela');
	}
}
